/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.admin;

import filenet.vw.apps.admin.VWAdminCore;
import filenet.vw.apps.admin.images.VWImageLoader;
import filenet.vw.apps.admin.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;

public class VWAdminApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWAdminCore m_adminCore = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(VWResource.s_pwAdministratorGroup)) {
                System.exit(1);
            }
            VWAdminApplication pApp = new VWAdminApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            System.exit(1);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            VWSplashWindow splashWindow = new VWSplashWindow(this);
            this.setFormattedWindowTitle(VWIDMBaseFactory.instance().getVWString(3).toString());
            ImageIcon icon = VWImageLoader.createImageIcon("admin_ico.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("admin_location", "admin_size")) {
                Dimension dim = VWStringUtils.stringToDimension("800,600");
                if (dim == null) {
                    dim = new Dimension(800, 600);
                }
                this.updatePosition(dim.width, dim.height);
            }
            this.setVisible(true);
            if (splashWindow != null) {
                splashWindow.start(this, 1000);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_adminCore = new VWAdminCore();
            this.m_adminCore.init(this.m_sessionInfo);
            try {
                if (!this.m_sessionInfo.isAllowedToRunAdministrationApp()) {
                    VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_insufficentRights, 1);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
                    return;
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
                return;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_adminCore != null) {
                this.m_adminCore.destroy();
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public void windowClosing(WindowEvent event) {
        if (event == null) {
            return;
        }
        if (event.getSource() == this && !this.m_adminCore.exitApp()) {
            return;
        }
        super.windowClosing(event);
    }
}

